/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

struct mx_endpoint;

#define MX_USE_SHMEM (!MX_OS_WINNT && !defined MX_KERNEL)

#if MX_USE_SHMEM

#define MX__SHM_SINGLE_QUEUE 1

#define MX__SHM_CACHELINE 128
#define MX__SHM_SMALLSIZE (512 - 56)
#define MX__SHM_MEDIUMSIZE (16*1024)

#define MX__SHM_REQ_FILESIZE (sizeof(struct mx__shm_queue) + sizeof (struct mx__shmreq) * MX__SHM_REQ_CNT)
#define MX__SHM_REQ_CNT 32 /* must be power of 2 */
#define MX__SHM_REQ_SLOT(cnt) ((cnt) & (MX__SHM_REQ_CNT - 1))

#define MX__SHM_FIFO_FILESIZE (512*1024)
#define MX__SHM_FIFO_LENGTH (MX__SHM_FIFO_FILESIZE - MX__SHM_MEDIUMSIZE - sizeof(struct mx__shm_fifo))

#define MX__SHM_REQ_SMALL 1
#define MX__SHM_REQ_MEDIUM 2
#define MX__SHM_REQ_LARGE 3
#define MX__SHM_REQ_ACK 4

struct mx__shmreq {
  char buf[MX__SHM_SMALLSIZE];
  uint64_t req_ptr;
  uint64_t length;
  uint64_t match_info;
  mx_shm_seg_t src_segs;
  uint32_t src_nsegs;
  uint32_t src_session;
  uint16_t peer_endpt;
  uint8_t pad1[5];
  uint8_t type;
};

struct mx__shm_queue {
  /* owner variables */
  uint32_t app_key;
  uint32_t read_idx;
  uint32_t waiting;
  uint32_t pid;
  uint32_t pad1[28];
  /* peer variables */
  uint32_t write_idx;
  uint32_t pad2[31];
  struct mx__shmreq queue[1];
};

struct mx__shm_fifo {
  /* owner variables */
  uint32_t send_idx;
  uint32_t sent;
  uint32_t pad[30];
  /* peer variables */
  uint32_t recv_idx;
  uint32_t rcvd;
  uint32_t pad1[30];
  char data[8];
};

struct mx__shm_info {
#if MX__SHM_SINGLE_QUEUE == 1
  struct mx__shm_queue *shmq;
  STAILQ_HEAD(,mx__bounce_req) bounce_reqq;
#endif
  struct mx__shm_peer {
    struct mx__shm_fifo *shm_snd_fifo;
    struct mx__shm_fifo *shm_rcv_fifo;
    struct mx__shm_queue *snd_shmq;
#if MX__SHM_SINGLE_QUEUE == 0
    struct mx__shm_queue *rcv_shmq;
#else
    void * pad;
#endif
  } *peers;
};

void mx__shm_send(struct mx_endpoint *ep, union mx_request *send);

void mx__shm_copy(struct mx_endpoint *ep, uint8_t peer_endpt, uint64_t peer_req,
		  mx_shm_seg_t *src_segs, uint32_t src_nsegs, uint32_t src_session,
		  union mx_request *recv);

void mx__shmem_luigi(mx_endpoint_t ep);

void *mx__shm_open(struct mx_endpoint *ep, uint16_t peer, int create, int data);
void mx__shm_close(struct mx_endpoint *ep, void *ptr, uint16_t peer, int create, int data);

/* to be used when the peer might have been closed/open so that
   further communication will reattached to the shared structures of
   the "new" endpoint */
void mx__shm_forget_peer(struct mx_endpoint *ep, uint16_t peer);

#endif /* USE_SHMEM */
